import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import numpy as np
import tkinter.filedialog as fd


fname = fd.askopenfilename()
t, r = np.loadtxt(fname, delimiter=',', usecols=(0,1),
                  unpack=True)

root = gc.create_window(title='Thermistor R-t Data Plot',
                        size='700x500')
ax, canvas = pc.create_plot(root)


pc.update_plot(ax, canvas, t, r,
               label_x='Temperature (deg Celsius)',
               label_y='Resistance (kOhm)',
               marker='o')

